/*
 ============================================================================
 Name		: Exam0302GuiAppView.cpp
 Author	  : 
 Copyright   : Your copyright notice
 Description : Application view implementation
 ============================================================================
 */

// INCLUDE FILES
#include <coemain.h>
#include "Exam0302GuiAppView.h"

// ============================ MEMBER FUNCTIONS ===============================

// -----------------------------------------------------------------------------
// CExam0302GuiAppView::NewL()
// Two-phased constructor.
// -----------------------------------------------------------------------------
//
CExam0302GuiAppView* CExam0302GuiAppView::NewL(const TRect& aRect)
	{
	CExam0302GuiAppView* self = CExam0302GuiAppView::NewLC(aRect);
	CleanupStack::Pop(self);
	return self;
	}

// -----------------------------------------------------------------------------
// CExam0302GuiAppView::NewLC()
// Two-phased constructor.
// -----------------------------------------------------------------------------
//
CExam0302GuiAppView* CExam0302GuiAppView::NewLC(const TRect& aRect)
	{
	CExam0302GuiAppView* self = new ( ELeave ) CExam0302GuiAppView;
	CleanupStack::PushL(self);
	self->ConstructL(aRect);
	return self;
	}

// -----------------------------------------------------------------------------
// CExam0302GuiAppView::ConstructL()
// Symbian 2nd phase constructor can leave.
// -----------------------------------------------------------------------------
//
void CExam0302GuiAppView::ConstructL(const TRect& aRect)
	{
	// Create a window for this application view
	CreateWindowL();

	// Set the windows size
	SetRect(aRect);

	// Activate the window, which makes it ready to be drawn
	ActivateL();
	}

// -----------------------------------------------------------------------------
// CExam0302GuiAppView::CExam0302GuiAppView()
// C++ default constructor can NOT contain any code, that might leave.
// -----------------------------------------------------------------------------
//
CExam0302GuiAppView::CExam0302GuiAppView()
	{
	// No implementation required
	}

// -----------------------------------------------------------------------------
// CExam0302GuiAppView::~CExam0302GuiAppView()
// Destructor.
// -----------------------------------------------------------------------------
//
CExam0302GuiAppView::~CExam0302GuiAppView()
	{
	// No implementation required
	}

// -----------------------------------------------------------------------------
// CExam0302GuiAppView::Draw()
// Draws the display.
// -----------------------------------------------------------------------------
//
void CExam0302GuiAppView::Draw(const TRect& /*aRect*/) const
	{
	// Get the standard graphics context
	CWindowGc& gc = SystemGc();

	// Gets the control's extent
	TRect drawRect(Rect());

	// Clears the screen
	gc.Clear(drawRect);

	}

// -----------------------------------------------------------------------------
// CExam0302GuiAppView::SizeChanged()
// Called by framework when the view size is changed.
// -----------------------------------------------------------------------------
//
void CExam0302GuiAppView::SizeChanged()
	{
	DrawNow();
	}
// End of File
