/*
 ============================================================================
 Name		: Exam0302GuiDocument.h
 Author	  : 
 Copyright   : Your copyright notice
 Description : Declares document class for application.
 ============================================================================
 */

#ifndef __EXAM0302GUIDOCUMENT_h__
#define __EXAM0302GUIDOCUMENT_h__

// INCLUDES
#include <akndoc.h>

// FORWARD DECLARATIONS
class CExam0302GuiAppUi;
class CEikApplication;

// CLASS DECLARATION

/**
 * CExam0302GuiDocument application class.
 * An instance of class CExam0302GuiDocument is the Document part of the
 * AVKON application framework for the Exam0302Gui example application.
 */
class CExam0302GuiDocument : public CAknDocument
	{
public:
	// Constructors and destructor

	/**
	 * NewL.
	 * Two-phased constructor.
	 * Construct a CExam0302GuiDocument for the AVKON application aApp
	 * using two phase construction, and return a pointer
	 * to the created object.
	 * @param aApp Application creating this document.
	 * @return A pointer to the created instance of CExam0302GuiDocument.
	 */
	static CExam0302GuiDocument* NewL(CEikApplication& aApp);

	/**
	 * NewLC.
	 * Two-phased constructor.
	 * Construct a CExam0302GuiDocument for the AVKON application aApp
	 * using two phase construction, and return a pointer
	 * to the created object.
	 * @param aApp Application creating this document.
	 * @return A pointer to the created instance of CExam0302GuiDocument.
	 */
	static CExam0302GuiDocument* NewLC(CEikApplication& aApp);

	/**
	 * ~CExam0302GuiDocument
	 * Virtual Destructor.
	 */
	virtual ~CExam0302GuiDocument();

public:
	// Functions from base classes

	/**
	 * CreateAppUiL
	 * From CEikDocument, CreateAppUiL.
	 * Create a CExam0302GuiAppUi object and return a pointer to it.
	 * The object returned is owned by the Uikon framework.
	 * @return Pointer to created instance of AppUi.
	 */
	CEikAppUi* CreateAppUiL();

private:
	// Constructors

	/**
	 * ConstructL
	 * 2nd phase constructor.
	 */
	void ConstructL();

	/**
	 * CExam0302GuiDocument.
	 * C++ default constructor.
	 * @param aApp Application creating this document.
	 */
	CExam0302GuiDocument(CEikApplication& aApp);

	};

#endif // __EXAM0302GUIDOCUMENT_h__
// End of File
