/*
 ============================================================================
 Name		: Exam0302GuiAppView.h
 Author	  : 
 Copyright   : Your copyright notice
 Description : Declares view class for application.
 ============================================================================
 */

#ifndef __EXAM0302GUIAPPVIEW_h__
#define __EXAM0302GUIAPPVIEW_h__

// INCLUDES
#include <coecntrl.h>

// CLASS DECLARATION
class CExam0302GuiAppView : public CCoeControl
	{
public:
	// New methods

	/**
	 * NewL.
	 * Two-phased constructor.
	 * Create a CExam0302GuiAppView object, which will draw itself to aRect.
	 * @param aRect The rectangle this view will be drawn to.
	 * @return a pointer to the created instance of CExam0302GuiAppView.
	 */
	static CExam0302GuiAppView* NewL(const TRect& aRect);

	/**
	 * NewLC.
	 * Two-phased constructor.
	 * Create a CExam0302GuiAppView object, which will draw itself
	 * to aRect.
	 * @param aRect Rectangle this view will be drawn to.
	 * @return A pointer to the created instance of CExam0302GuiAppView.
	 */
	static CExam0302GuiAppView* NewLC(const TRect& aRect);

	/**
	 * ~CExam0302GuiAppView
	 * Virtual Destructor.
	 */
	virtual ~CExam0302GuiAppView();

public:
	// Functions from base classes

	/**
	 * From CCoeControl, Draw
	 * Draw this CExam0302GuiAppView to the screen.
	 * @param aRect the rectangle of this view that needs updating
	 */
	void Draw(const TRect& aRect) const;

	/**
	 * From CoeControl, SizeChanged.
	 * Called by framework when the view size is changed.
	 */
	virtual void SizeChanged();

private:
	// Constructors

	/**
	 * ConstructL
	 * 2nd phase constructor.
	 * Perform the second phase construction of a
	 * CExam0302GuiAppView object.
	 * @param aRect The rectangle this view will be drawn to.
	 */
	void ConstructL(const TRect& aRect);

	/**
	 * CExam0302GuiAppView.
	 * C++ default constructor.
	 */
	CExam0302GuiAppView();

	};

#endif // __EXAM0302GUIAPPVIEW_h__
// End of File
