/*
 ============================================================================
 Name		: Exam0302GuiAppUi.h
 Author	  : 
 Copyright   : Your copyright notice
 Description : Declares UI class for application.
 ============================================================================
 */

#ifndef __EXAM0302GUIAPPUI_h__
#define __EXAM0302GUIAPPUI_h__

// INCLUDES
#include <aknappui.h>

// FORWARD DECLARATIONS
class CExam0302GuiAppView;

// CLASS DECLARATION
/**
 * CExam0302GuiAppUi application UI class.
 * Interacts with the user through the UI and request message processing
 * from the handler class
 */
class CExam0302GuiAppUi : public CAknAppUi
	{
public:
	// Constructors and destructor

	/**
	 * ConstructL.
	 * 2nd phase constructor.
	 */
	void ConstructL();

	/**
	 * CExam0302GuiAppUi.
	 * C++ default constructor. This needs to be public due to
	 * the way the framework constructs the AppUi
	 */
	CExam0302GuiAppUi();

	/**
	 * ~CExam0302GuiAppUi.
	 * Virtual Destructor.
	 */
	virtual ~CExam0302GuiAppUi();

private:
	// Functions from base classes

	/**
	 * From CEikAppUi, HandleCommandL.
	 * Takes care of command handling.
	 * @param aCommand Command to be handled.
	 */
	void HandleCommandL(TInt aCommand);

	/**
	 *  HandleStatusPaneSizeChange.
	 *  Called by the framework when the application status pane
	 *  size is changed.
	 */
	void HandleStatusPaneSizeChange();

	/**
	 *  From CCoeAppUi, HelpContextL.
	 *  Provides help context for the application.
	 *  size is changed.
	 */
	CArrayFix<TCoeHelpContext>* HelpContextL() const;

private:
	// Data

	/**
	 * The application view
	 * Owned by CExam0302GuiAppUi
	 */
	CExam0302GuiAppView* iAppView;

	};

#endif // __EXAM0302GUIAPPUI_h__
// End of File
