
/*
* ============================================================================
*  Name     : CShapeResolver from shaperesolver.cpp
*  Part of  : shaperesolver
*  Created  : 17/11/2003 by Forum Nokia
*  Implementation notes:
*  Version  : 1.0
*  Copyright: Forum Nokia
* ============================================================================
*/

// INCLUDE FILES
#include <ecom/ecom.h>
#include <ecom/ecomerrorcodes.h>
#include <ecom/ecomresolverparams.h>
#include <ecom/implementationinformation.h>
#include <ecom/publicregistry.h>

#include "shapeResolver.h"

/// Creates an instance of CShapeResolver
CShapeResolver* CShapeResolver::NewL (MPublicRegistry& aRegistry)
    {
    return new(ELeave) CShapeResolver (aRegistry);
    }

// Destructor.
CShapeResolver::~CShapeResolver()
    {
    if(iImplementationInfoArray)
        {
        iImplementationInfoArray->Reset();
        delete iImplementationInfoArray;
        }
    }

/// Constructor of CShapeResolver
CShapeResolver::CShapeResolver (MPublicRegistry& aRegistry) :
    CResolver (aRegistry)
    {
    }

/// This method determines if it can find an appriate implementation
/// requested
TUid CShapeResolver::IdentifyImplementationL(TUid aInterfaceUid,
    const TEComResolverParams& aAdditionalParameters) const
    {
    // Aquire a list of implementations for a specific implementation defintion
    RImplInfoArray& implementationsInfo = iRegistry.ListImplementationsL (
        aInterfaceUid);
    TUid found = KNullUid;

    if (implementationsInfo.Count())
        {
        found = Resolve (implementationsInfo, aAdditionalParameters);
        }
    return found;
    }

/// This method iterates through a list of RImplInfoArray() objects to
/// find the most appropriate implementation.
TUid CShapeResolver::Resolve(const RImplInfoArray& aImplementationsInfo,
    const TEComResolverParams& aAdditionalParameters) const
    {
    const TInt count = aImplementationsInfo.Count();
    for (TInt i = 0; i < count; ++i)
        {
        const CImplementationInformation& impData = *aImplementationsInfo[i];

        // Checks each item in the list to see if theres a match.
        if (Match (impData.DataType(), aAdditionalParameters.DataType(),
            aAdditionalParameters.IsWildcardMatch()))
            {
            // Returns the Uid of the interface
            return impData.ImplementationUid();
            }
        }

    // Nothing found
    return KNullUid;
    }

/// Lists all the implementations of the specified interface definition that
/// satisfy the supplied resolution parameters.
RImplInfoArray* CShapeResolver::ListAllL(TUid aInterfaceUid,
    const TEComResolverParams& aAdditionalParameters) const
    {
    // Use the member variable to create the array so
    // proper cleanup behaviour is achieved
    iImplementationInfoArray = new (ELeave) RImplInfoArray;
    RImplInfoArray* retList = iImplementationInfoArray;

    RImplInfoArray& fullList = iRegistry.ListImplementationsL (aInterfaceUid);

    const TBool useWildcards = aAdditionalParameters.IsWildcardMatch();
    const TDesC8& matchType = aAdditionalParameters.DataType();
    const TInt numImps = fullList.Count();

    // Iterates through each item in the list to determine the correct
    // interfaces to select.
    for (TInt i = 0; i < numImps; ++i)
        {
        if (Match (fullList[i]->DataType(), matchType, useWildcards))
            {
            // Adds interface to the list.
            User::LeaveIfError (retList->Append (fullList[i]));
            }
        }

    // Reset the member variable because we are passing ownership back
    iImplementationInfoArray = NULL;

    return retList;
    }

/// The first two parameters is used for comparaison between the two interfaces
/// and the third parameter is used to determine the use of wild cards or not.
TBool CShapeResolver::Match(const TDesC8& aImplementationType,
    const TDesC8& aMatchType, TBool aUseWildcards) const
    {
    TInt matchPos = KErrNotFound;

    // If wild cards have been set, it will use the correct method to determine
    // the correct interface.
    if (aUseWildcards)
            matchPos = aImplementationType.MatchF (aMatchType);
    else
            matchPos = aImplementationType.CompareF (aMatchType);

    return matchPos != KErrNotFound;
    }


