
/*
* ============================================================================
*  Name     : shapeinterface.inl
*  Part of  : ECom plug-in interface definition
*  Created  : 17/11/2003 by Forum Nokia
*  Implementation notes:
*	Defines the ECom shape plug-in interface include file
*  Version  : 1.0
*  Copyright: Forum Nokia
* ============================================================================
*/

// Interface's (abstract base class's) static factory method implementation.
// Asks ECOM plugin framework to instantiate appropriate concret plugin
// implementation.
inline CShape* CShape::NewL()
	{
	// Wish to instantiate the default interface - Circle
	const TUid KCCircleInterfaceUid = {0x101F6150};

	// Find implementation for our interface.
    // - KCCircleInterfaceUid is the UID of our custom ECOM
    //   interface.
    // - This call will leave, if the plugin architecture cannot find
    //   implementation.
    // - The returned pointer points to one of our interface implementation
    //   instances.
	TAny* interface = REComSession::CreateImplementationL (
		KCCircleInterfaceUid, _FOFF (CShape, iDtor_ID_Key));

	return reinterpret_cast <CShape*> (interface);
	}

// Interface's (abstract base class's) static factory method implementation.
// Asks ECOM plugin framework to instantiate appropriate concret plugin
// implementation.
inline CShape* CShape::NewL(const TDesC8& aMatch)
	{
	const TUid KCShapeInterfaceUid = {0x101F614C};
	const TUid KCShapeResolverUid = {0x101F614E};

	TEComResolverParams resolverParams;
	resolverParams.SetDataType (aMatch);
	resolverParams.SetWildcardMatch (ETrue);

	// Find implementation for our interface.
	// - KCCircleInterfaceUid is the UID of our custom ECOM
	//   interface. It is defined in EComInterfaceDefinition.h
	// - This call will leave, if the plugin architecture cannot find
	//   implementation.
	// - The returned pointer points to one of our interface implementation
    //   instances.
	TAny* interface = REComSession::CreateImplementationL (KCShapeInterfaceUid,
		_FOFF (CShape, iDtor_ID_Key), resolverParams, KCShapeResolverUid);

	return reinterpret_cast <CShape*> (interface);
	}


// Interface's (abstract base class's) destructor
inline CShape::~CShape()
	{
	// If in the NewL some memory is reserved for member data, it must be
	// released here. This interface does not have any instance variables so
	// no need to delete anything.

	// Inform the ECOM framework that this specific instance of the
    // interface has been destroyed.
	REComSession::DestroyedImplementation (iDtor_ID_Key);
	}

