
/*
* ============================================================================
*  Name     : shapeinterface.h
*  Part of  : ECom plug-in interface definition
*  Created  : 17/11/2003 by Forum Nokia
*  Implementation notes:
*	Defines the ECom shape plug-in interface
*  Version  : 1.0
*  Copyright: Forum Nokia
* ============================================================================
*/

#ifndef __SHAPEINTERFACE_H__
#define __SHAPEINTERFACE_H__

// INCLUDES
#include <ecom/ecom.h>

// FORWARD DECLARATIONS
class CWindowGc;

/**
 * Class:       pe
 *
 * Description: Custom ECOM interface definition. This interface is used by
 *              clients to find specific instance and display various shapes
 *              to screen. Plugin implementations implement the Draw
 *              function.
 */
class CShape : public CBase
	{
public: // Constructors and destructor
	/**
	 * Function:   NewL
	 *
	 * Description: Wraps ECom object instantitation. Will return the
	 *              default interface implementation, which matches to
	 *              given aOperationName.
	 *
	 * Note:        This is not a "normal" NewL method, since normally NewL
	 *              methods are only defined for concrete classes.
	 *              Note that also implementations of this interface
	 *              provide NewL methods. They are the familiar NewL's,
	 *              which create instance of classes.
     */
	static CShape* NewL();

	/**
     * Function:   NewL
     *
     * Description: Wraps ECom object instantitation. Will search for
     *              interface implementation, which matches to given
     *              aOperationName.
     *
     * Param:       aOperationName name of requested implementation.
     *              Implementations advertise their "name" as specified
     *              in their resource file field
     *                 IMPLEMENTATION_INFO::default_data.
     *              For details, see EcomShapeDefinition.inl comments.
     *              In this example, the allowed values are "Circle", "Square"
     *              and "Triangle".
     *
     * Note:        This is not a "normal" NewL method, since normally NewL
     *              methods are only defined for concrete classes.
     *              Note that also implementations of this interface provide
     *              NewL methods. They are the familiar NewL's, which create
     *              instance of classes.
     */
	static CShape* NewL(const TDesC8& aMatch);

	/**
	 * Function:    ~CShape
	 *
	 * Description: Destroy the object
     */
	virtual ~CShape();

public:
	/**
	 * Function:    Draw
	 *
	 * Description: Public interface service. Abstract method responible for
	 *              drawing a shape to screen. The result of Draw
	 *              depends on the implementation.
	 *
	 * Param:       aGraphicsContext used to display image to screen
     */
	virtual void Draw(CWindowGc& aGraphicsContext) const = 0;

private:
	/** iDtor_ID_Key Instance identifier key. When instance of an
	 *               implementation is created by ECOM framework, the
	 *               framework will assign UID for it. The UID is used in
	 *               destructor to notify framework that this instance is
	 *               being destroyed and resources can be released.
     */
	TUid iDtor_ID_Key;
	};

// This includes the implementation of the instantiation functions and
// destructor
#include "shapeinterface.inl"

#endif

