
/*
* ============================================================================
*  Name     : CTriangle from triangle.cpp
*  Part of  : plugin
*  Created  : 17/11/2003 by Forum Nokia
*  Version  : 1.0
*  Copyright: Forum Nokia
* ============================================================================
*/

// INCLUDE FILES
#include <w32std.h>

#include "triangle.h"

// Create instance of concrete ECOM interface implementation
CTriangle* CTriangle::NewL()
    {
    CTriangle* self = new (ELeave) CTriangle;
    CleanupStack::PushL (self);
    self->ConstructL();
    CleanupStack::Pop(self);
    return self;
    }

// Implementation of CShape
void CTriangle::Draw(CWindowGc& aGraphicsContext) const
    {
    // Co-ordinates for triangke
    const TInt KPointAX = 50;
    const TInt KPointAY = 25;

    const TInt KPointBX = 25;
    const TInt KPointBY = 75;

    const TInt KPointCX = 75;
    const TInt KPointCY = 75;
    TPoint point1;
    TPoint point2;

    point1.SetXY (KPointAX, KPointAY);
    point2.SetXY (KPointBX, KPointBY);

    aGraphicsContext.DrawLine (point1, point2);

    point1.SetXY (KPointAX, KPointAY);
    point2.SetXY (KPointCX, KPointCY);

    aGraphicsContext.DrawLine (point1, point2);

    point1.SetXY (KPointBX, KPointBY);
    point2.SetXY (KPointCX, KPointCY);

    aGraphicsContext.DrawLine (point1, point2);
    }

// Constructor
CTriangle::CTriangle()
    {
    }

// Second phase construction.
void CTriangle::ConstructL()
    {
    }




