
/*
* ============================================================================
*  Name     : Proxy.cpp
*  Part of  : plugin
*  Created  : 17/11/2003 by Forum Nokia
*  Implementation notes:
*   provides a proxy table for Interface implementations
*  Version  : 1.0
*  Copyright: Forum Nokia
* ============================================================================
*/

// INCLUDE FILES
#include <e32std.h>
#include <ecom/implementationproxy.h>

#include "circle.h"
#include "square.h"
#include "triangle.h"

// Provides a key value pair table, this is used to identify
// the correct construction function for the requested interface.
const TImplementationProxy ImplementationTable[] =
    {
        #ifdef __SERIES60_3X__

            IMPLEMENTATION_PROXY_ENTRY(0x101F6150,  CCircle::NewL),
            IMPLEMENTATION_PROXY_ENTRY(0x101F6151,  CSquare::NewL),
            IMPLEMENTATION_PROXY_ENTRY(0x101F6152,  CTriangle::NewL)

        #else
            {{0x101F6150},  CCircle::NewL},
            {{0x101F6151},  CSquare::NewL},
            {{0x101F6152},  CTriangle::NewL}
        #endif
    };

// Function used to return an instance of the proxy table.
EXPORT_C const TImplementationProxy* ImplementationGroupProxy(TInt& aTableCount)
    {
    aTableCount = sizeof(ImplementationTable) / sizeof(TImplementationProxy);
    return ImplementationTable;
    }

