
/*
* ============================================================================
*  Name     : CSquare from square.h
*  Part of  : plugin
*  Created  : 17/11/2003 by Forum Nokia
*  Description:
*     Implements the drawing of a square
*  Version  : 1.0
*  Copyright: Forum Nokia
* ============================================================================
*/

#ifndef __SQUARE_H__
#define __SQUARE_H__

// INCLUDES
#include <shapeinterface.h>

/**
 * Class:       CSquare
 *
 * Description: An implementation of the CShape definition. Displays a square
 *              shape to screen. This is concrete class, instance of which
 *              ECOM framework gives to ECOM clients.
 */
class CSquare : public CShape
	{
public:
	/**
     * Function:    NewL
     *
     * Description: Create instance of concrete implementation. Note that ECOM
     *              interface implementations can only have two signatures for
     *              NewL:
     *               - NewL without parameters (used here)
     *               - NewL with TAny* pointer, which may provide some client
     *                 data
     *
     * Returns:    Instance of this class.
     *
     * Note:       The interface, which is abstract base class of this
     *             implementation, also provides NewL method. Normally abstract
     *             classes do not provide NewL, because they cannot create
     *             instances of themselves.
     */
	static CSquare* NewL();

public: // CShape
	/**
     * Function:    ConstructL
     *
     * Description: Draws shape of object
	 *
	 * Param:       aGraphicsContext graphics context to display result
     */
	virtual void Draw(CWindowGc& aGraphicsContext) const;

protected:
	/**
     * Function:   CSquare
     *
     * Discussion: Perform the first phase of two phase construction
     */
	CSquare();

	/**
     * Function:   ConstructL
     *
     * Discussion: Perform the second phase construction of a
     *             CImplementationClassPlus object.
     */	
	void ConstructL();
	};

#endif

