/*
* ============================================================================
*  Name     : CEcomShapeContainer from EcomshapeContainer.h
*  Part of  : ecomshape
*  Created  : 29/05/2006 by Forum Nokia
*  Version  : 2.0
*  Copyright: Forum Nokia
* ============================================================================
*/

// INCLUDE FILES
#include <eiklabel.h>  // for example label control
#include <shapeinterface.h> // ECom Shape plug-in

#include "EcomshapeContainer.h"


// Perform the second phase construction. This is allowed to leave.
void CEcomShapeContainer::ConstructL(const TRect& aRect)
    {
	// Creates a default implementation of an ECom Shape object
	iDefault = CShape::NewL();
	
	// Create an instance of Circle Ecom object
	_LIT8 (KCircleText,"Circle");
	iCircle = CShape::NewL(KCircleText);

	// Create an instance of Square Ecom object
	_LIT8 (KSquareText,"Square");
	iSquare = CShape::NewL(KSquareText);

	// Create an instance of Triangle Ecom object
	_LIT8 (KTriangleText,"Triangle");
    iTriangle = CShape::NewL(KTriangleText);

	CreateWindowL();
	
	// Sets the state to display the default ECom implementation 
	iState = EDefault;
    SetRect(aRect);
    ActivateL();
    }

// Destructor. Release ecom objects.
CEcomShapeContainer::~CEcomShapeContainer()
    {
	delete iDefault;
	delete iCircle;
	delete iSquare;
	delete iTriangle;
    }


// Draws the default shape
void CEcomShapeContainer::DrawDefault()
	{
	// Sets the state to default
	iState = EDefault;
	DrawDeferred();
	}

// Draws a circle
void CEcomShapeContainer::DrawCircle()
	{
	// Sets the state to circle
	iState = ECircle;
	DrawDeferred();
	}

// Draws a square
void CEcomShapeContainer::DrawSquare()
	{
	// Sets the state to square
	iState = ESquare;
	DrawDeferred();
	}

// Draws a triangle
void CEcomShapeContainer::DrawTriangle()
	{
	// Sets the state to triangle
	iState = ETriangle;
	DrawDeferred();
	}

// Called by framework when the view size is changed
void CEcomShapeContainer::SizeChanged()
    {
    }

// Returns the number of component controls
TInt CEcomShapeContainer::CountComponentControls() const
    {
    return 0; // return nbr of controls inside this container
    }

CCoeControl* CEcomShapeContainer::ComponentControl(TInt /*aIndex*/) const
    {
    return NULL;
    }

// Draws the various ecom objects depending on state
void CEcomShapeContainer::Draw(const TRect& aRect) const
    {
    CWindowGc& gc = SystemGc();
    gc.SetBrushColor(KRgbWhite);
	gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
    gc.DrawRect(aRect);
	
	// Determine state of container, this will determine
	// what shape is displayed to screen.
	switch (iState)
		{
		case ECircle:
			iCircle->Draw(gc);
			break;
		case ESquare:
			iSquare->Draw(gc);
			break;
		case ETriangle:
			iTriangle->Draw(gc);
			break;
		default:
			iDefault->Draw(gc);
		};
    }

// End of File  
