/*
* ============================================================================
*  Name     : CEcomShapeAppUi from EcomshapeAppUi.cpp
*  Part of  : ecomshape
*  Created  : 29/06/2006 by Forum Nokia
*  Version  : 2.0
*  Copyright: Forum Nokia
* ============================================================================
*/

// INCLUDE FILES
#include <avkon.hrh>

#include "EcomshapeAppUi.h"
#include "EcomshapeContainer.h" 
#include <ecomshape.rsg>
#include "ecomshape.hrh"

// Perform the second phase construction. This is allowed to leave.
void CEcomShapeAppUi::ConstructL()
    {
    BaseConstructL(EAknEnableSkin);
    iAppContainer = new (ELeave) CEcomShapeContainer;
    iAppContainer->SetMopParent(this);
    iAppContainer->ConstructL( ClientRect() );
    AddToStackL( iAppContainer );
    }

// Destructor. Release reserved resources.
CEcomShapeAppUi::~CEcomShapeAppUi()
    {
    if (iAppContainer)
        {
        RemoveFromStack( iAppContainer );
        delete iAppContainer;
        }
        
    #ifdef __SERIES60_3X__
    	REComSession::FinalClose();
    #endif        
   }

// Handle menu commands. The commands are defined in EComShape.hrh
void CEcomShapeAppUi::HandleCommandL(TInt aCommand)
    {
    switch ( aCommand )
        {
        case EAknSoftkeyBack:
        case EEikCmdExit:
            {
            Exit();
            break;
            }
		case EEComDefault:
            {
            iAppContainer->DrawDefault();
            break;
            }
		case EEComCircle:
            {
            iAppContainer->DrawCircle();
            break;
            }
		case EEComSquare:
            {
            iAppContainer->DrawSquare();
            break;
            }
        case EEComTriangle:
            {
            iAppContainer->DrawTriangle();
            break;
            }
        default:
            break;      
        }
    }

// Handles errors
TErrorHandlerResponse CEcomShapeAppUi::HandleError(TInt aError,
	const SExtendedError& /*aExtErr*/, TDes& aErrorText,TDes& /*aContextText*/)
	{
	if (aError == KErrPermissionDenied)
		{
		_LIT (KMissingEcomPlugin, "Permission denied");
		aErrorText = KMissingEcomPlugin;
		aErrorText.AppendNum(aError);
		return EAlertDisplay;
		}
	else if ( aError )
	    {
		_LIT (KMissingEcomPlugin, "Missing shape plugin or resolver");
		aErrorText = KMissingEcomPlugin;
		aErrorText.AppendNum(aError);
		return EAlertDisplay;	    
	    }
	return EErrorNotHandled;
	}

void CEcomShapeAppUi::HandleResourceChangeL(TInt aType)
    {
    CAknAppUi::HandleResourceChangeL(aType); //call to upper class

    // ADDED FOR SCALABLE UI SUPPORT
    // *****************************
    if ( aType == KEikDynamicLayoutVariantSwitch )
        {
        iAppContainer->SetRect( ClientRect() );
        }
    }

// End of File  
