/*
* ============================================================================
*  Name     : CEcomShapeApp from EcomshapeApp.cpp
*  Part of  : ecomshape
*  Created  : 29/05/2006 by Forum Nokia
*  Version  : 2.0
*  Copyright: Forum Nokia
* ============================================================================
*/

// INCLUDE FILES
#include    "EcomshapeApp.h"
#include    "EcomshapeDocument.h"
#ifdef __SERIES60_3X__
#include <eikstart.h>
#endif

// Returns application UID
TUid CEcomShapeApp::AppDllUid() const
    {
    return KUidecomshape;
    }

// Creates CEcomShapeDocument object
CApaDocument* CEcomShapeApp::CreateDocumentL()
    {
    return CEcomShapeDocument::NewL( *this );
    }

// Constructs CEcomShapeApp
EXPORT_C CApaApplication* NewApplication()
    {
    return new CEcomShapeApp;
    }

#ifndef __SERIES60_3X__
// Entry point function for EPOC Apps
// Returns: KErrNone: No error
GLDEF_C TInt E32Dll( TDllReason )
    {
    return KErrNone;
    }
#else
// ---------------------------------------------------------
// E32Main()
// Entry point function for new (>= 9.0) EPOC Apps (exe)
// Returns: Sistem Wide error codes or KErrNone if all goes well
// ---------------------------------------------------------
//
GLDEF_C TInt E32Main()
{
    return EikStart::RunApplication( NewApplication );
}
#endif

// End of File
