/*
* ============================================================================
*  Name     : CEcomShapeDocument from EcomshapeDocument.h
*  Part of  : ecomshape
*  Created  : 17/11/2003 by Forum Nokia
*  Description:
*     Declares document for application.
*  Version  : 1.0
*  Copyright: Forum Nokia
* ============================================================================
*/

#ifndef ECOMSHAPEDOCUMENT_H
#define ECOMSHAPEDOCUMENT_H

// INCLUDES
#include <akndoc.h>

// FORWARD DECLARATIONS
class  CEikAppUi;

/**
 * Class:      CEcomShapeDocument
 *
 * Discussion: An instance of class CEcomShapeDocument is the Document
 *             part of the AVKON application framework for the ECom shape
 *             example application.
 */
class CEcomShapeDocument : public CAknDocument
    {
public: // Constructors and destructor
    /**
     * Function:  NewL
     *
     * Discussion: Construct a CEComShapeDocument for the AVKON
     *             application aApp using two phase construction, and return
     *             a pointer to the created object.
     *
     * Param:      aApp application creating this document
     *
     * Returns:    A pointer to the created instance of CEComShapeDocument
     */
    static CEcomShapeDocument* NewL(CEikApplication& aApp);

    /**
     * Function:   ~CEcomShapeDocument
     *
     * Discussion: Destroy the object
     */
    virtual ~CEcomShapeDocument();

private:

    /**
     * Function:   CEComShapeDocument
     *
     * Discussion: Perform the first phase of two phase construction
     *
     * Param:      aApp application creating this document
     */
    CEcomShapeDocument(CEikApplication& aApp);

	/**
     * Function:   ConstructL
     *
     * Discussion: Perform the second phase construction of a
     *             CEcomShapeDocument object.
     */
    void ConstructL();

private:

    /**
     * Function:   CreateAppUiL
     *
     * Discussion: Create a CEComShapeDocument object and return a
     *             pointer to it.
     *
     * Returns:     A pointer to the created instance of the AppUi created
     */
    CEikAppUi* CreateAppUiL();
    };

#endif

// End of File

