/*
* ============================================================================
*  Name     : CEcomShapeContainer from EcomshapeContainer.h
*  Part of  : ecomshape
*  Created  : 17/11/2003 by Forum Nokia
*  Description:
*     Declares container control for application.
*  Version  : 1.0
*  Copyright: Forum Nokia
* ============================================================================
*/

#ifndef ECOMSHAPECONTAINER_H
#define ECOMSHAPECONTAINER_H

// INCLUDES
#include <coecntrl.h>
   
// FORWARD DECLARATIONS
class CShape;  // ECom plug-in


/**
 * Class:       CEcomShapeContainer
 *
 * Description: An instance of this class is the Application View object for
 *              the EComShape example application. It displays the requested
 *              shape chosen by the user.
 */			   
class CEcomShapeContainer : public CCoeControl
    {
public: // Constructors and destructor

    /**
     * Function:    ConstructL
     *
     * Description: Perform the second phase construction of a
     *              CEComShapeAppView object.
     *
     * Param:       aRect the rectangle this view will be drawn to
     */
    void ConstructL(const TRect& aRect);

    /**
     * Function:    ~CEcomShapeAppUi
     *
     * Description: Destroy the object
     */    
    ~CEcomShapeContainer();

public:
	/**
     * Function:    DrawDefault
     *
     * Description: Draw default ECom plug-in shape
     */
	void DrawDefault();

	/**
     * Function:    DrawCircle
     *
     * Description: Draw a cicle.
     */
	void DrawCircle();

	/**
     * Function:    DrawSquare
     *
     * Description: Draw a square.
     */
	void DrawSquare();

	/**
     * Function:    DrawTriangle
     *
     * Description: Draw a triangle.
     */
	void DrawTriangle();

private:
	/**
     * Numerator:    TContainerState
     *
     * Description:  Used to secify state of container..
     */
	enum TContainerState
		{
		EDefault = 0, ///< Default shape
		ECircle,      ///< Circle
		ESquare,      ///< Square
		ETriangle     ///< Triangle
		};

private:
	/**
     * Function:    SizeChanged
     *
     * Description: From CoeControl,SizeChanged.
     */
    void SizeChanged();

    /**
     * Function:    CountComponentControls
     *
     * Description: From CoeControl,CountComponentControls.
	 *
	 * Return:      The number of component controls contained by this control.
     */
    TInt CountComponentControls() const;

	/**
     * Function:    ComponentControl
     *
     * Description: From CCoeControl,ComponentControl.
	 *
	 * Param:       aIndex the index of the control to get
	 *
	 * Return:      The component control with an index of aIndex
     */
	//
    CCoeControl* ComponentControl(TInt aIndex) const;
   
	/**
     * Function:    Draw
     *
     * Description: From CCoeControl,Draw.
	 *
	 * Param:       aRect the rectangle this view will be drawn to
     */
    void Draw(const TRect& aRect) const;
    
private: //data
	TContainerState iState;
	CShape* iDefault;
	CShape*	iCircle;
	CShape*	iSquare;
	CShape*	iTriangle;
    };

#endif

// End of File
