/*
* ============================================================================
*  Name     : CEcomShapeAppUi from EcomshapeAppUi.h
*  Part of  : ecomshape
*  Created  : 29/05/2006 by Forum Nokia
*  Description:
*     Declares UI class for application.
*  Version  : 2.0
*  Copyright: Forum Nokia
* ============================================================================
*/

#ifndef ECOMSHAPEAPPUI_H
#define ECOMSHAPEAPPUI_H

// INCLUDES
#include <eikapp.h>
#include <eikdoc.h>
#include <e32std.h>
#include <coeccntx.h>
#include <aknappui.h>

// FORWARD DECLARATIONS
class CEcomShapeContainer;

/**
 * Class: CEcomShapeAppUi
 *
 * Description: An instance of class CEComShapeAppUi is the UserInterface
 *              part of the AVKON application framework for the EComShape
 *              example application
 *
 */
class CEcomShapeAppUi : public CAknAppUi
    {
public: // Constructors and destructor

    /**
     * Function:    ConstructL
     *
     * Description: Perform the second phase construction of a
     *              CEComShapeAppUi object. this needs to be public due to
     *              the way the framework constructs the AppUi.
     */
    void ConstructL();

    /**
     * Function:    ~CEcomShapeAppUi
     *
     * Description: Destroy the object
     */
    ~CEcomShapeAppUi();

public:
    //from CAknAppUi
    void HandleResourceChangeL(TInt aType);

private:
    /**
     * Function:    HandleCommandL
     *
     * Description: Handle user menu selections
     *
     * Param:       aCommand the enumerated code for the menu option selected
     */
    void HandleCommandL(TInt aCommand);

private: // CAknAppUi

    /**
     * Function:    HandleError
     *
     * Description: Handles errors
     *
     * Param:       aError the error code.
     * Param:       aExtErr for extended error messages.
     * Param:       aErrorText Error text.
     * Param:       aContextText Text describing the context of the error.
     *
     * Return:      How the error was handled.
     */
    TErrorHandlerResponse HandleError(TInt aError,const SExtendedError& aExtErr,
        TDes& aErrorText,TDes& aContextText);

private: //Data
    CEcomShapeContainer* iAppContainer;
    };

#endif

// End of File
