/*
* ============================================================================
*  Name     : CEcomShapeApp from EcomshapeApp.h
*  Part of  : ecomshape
*  Created  : 29/05/2006 by Forum Nokia
*  Description:
*     Declares main application class.
*  Version  : 2.0
*  Copyright: Forum Nokia
* ============================================================================
*/

#ifndef ECOMSHAPEAPP_H
#define ECOMSHAPEAPP_H

// INCLUDES
#include <aknapp.h>

// CONSTANTS
// UID of the application
#ifdef __SERIES60_3X__
    const TUid KUidecomshape = { 0xE01FDA6D };
#else
    const TUid KUidecomshape = { 0x101FDA6D };
#endif
// CLASS DECLARATION

/**
 * Class:      CEcomShapeApp
 * Description:An instance of CEcomShapeApp is the application
 *             part of the AVKON application framework for the EComShape
 *             example application.
 *
 *             EComShape is an ECOM client application. It uses custom
 *             ECOM interface to access plugin implementations.
 *
 *             See EComShapeAppui.cpp how the custom interface is used.
 *             See the custom interface definition in ..\..\shaperesolver
 *             For more information on ECOM architecture, see the ECom
 *             section in S60 v2.0 SDK Help.
 *
 */
class CEcomShapeApp : public CAknApplication
    {
public: // Functions from base classes
    /**
     * Function:    OpenIniFileLC
     * Description: From CApaApplication, overridden to enable INI file support.
     * Returns:     A pointer to the dictionary store
     */
private:

    /**
     * Function:    CreateDocumentL
     * Description: Create a CApaDocument object and return a pointer to it.
     * Returns:     A pointer to the created document
     */
    CApaDocument* CreateDocumentL();

    /**
     * Function:    AppDllUid
     * Description: Return the application DLL UID value
     * Returns:     The UID of this Application Dll
     */
    TUid AppDllUid() const;
    };

#endif

// End of File

